% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opq.R
\name{opq_around}
\alias{opq_around}
\title{opq_around}
\usage{
opq_around(lon, lat, radius = 15, key = NULL, value = NULL, timeout = 25)
}
\arguments{
\item{lon}{Longitude of desired point}

\item{lat}{Latitude of desired point}

\item{radius}{Radius in metres around the point for which data should be
extracted. Queries with  large values for this parameter may fail.}

\item{key}{(Optional) OSM key of enclosing data}

\item{value}{(Optional) OSM value matching 'key' of enclosing data}

\item{timeout}{It may be necessary to increase this value for large queries,
because the server may time out before all data are delivered.}
}
\description{
Find all features around a given point, and optionally match specific
'key'-'value' pairs. This function is \emph{not} intended to be combined with
\link{add_osm_feature}, rather is only to be used in the sequence
\link{opq_around} -> \link{osmdata_xml} (or other extraction function). See
examples for how to use.
}
\examples{
\dontrun{
# Get all benches ("amenity=bench") within 100m of a particular point
lat <- 53.94542
lon <- -2.52017
key <- "amenity"
value <- "bench"
radius <- 100
x <- opq_around (lon, lat, radius, key, value) |>
    osmdata_sf ()
}
}
\seealso{
Other queries: 
\code{\link{add_osm_feature}()},
\code{\link{add_osm_features}()},
\code{\link{bbox_to_string}()},
\code{\link{getbb}()},
\code{\link{opq}()},
\code{\link{opq_csv}()},
\code{\link{opq_enclosing}()},
\code{\link{opq_osm_id}()},
\code{\link{opq_string}()},
\code{\link{overpass_status}()}
}
\concept{queries}
