% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_calibrate.R
\name{p_calibrate}
\alias{p_calibrate}
\alias{p_calibrate.default}
\title{Calculate calibrated p-values.}
\usage{
p_calibrate(x, ...)

\method{p_calibrate}{default}(x, type = "frequentist", verbose = TRUE, ...)
}
\arguments{
\item{x}{A numeric vector of p-values, or a regression model object.}

\item{...}{Currently not used.}

\item{type}{Type of calibration. Can be \code{"frequentist"} or \code{"bayesian"}.
See 'Details'.}

\item{verbose}{Toggle warnings.}
}
\value{
A data frame with p-values and calibrated p-values.
}
\description{
Compute calibrated p-values that can be interpreted
probabilistically, i.e. as posterior probability of H0 (given that H0
and H1 have equal prior probabilities).
}
\details{
The Bayesian calibration, i.e. when \code{type = "bayesian"}, can be interpreted
as the lower bound of the Bayes factor for H0 to H1, based on the data.
The full Bayes factor would then require multiplying by the prior odds of
H0 to H1. The frequentist calibration also has a Bayesian interpretation; it
is the posterior probability of H0, assuming that H0 and H1 have equal
prior probabilities of 0.5 each (\emph{Sellke et al. 2001}).

The calibration only works for p-values lower than or equal to \code{1/e}.
}
\examples{
model <- lm(mpg ~ wt + as.factor(gear) + am, data = mtcars)
p_calibrate(model, verbose = FALSE)
}
\references{
Thomas Sellke, M. J Bayarri and James O Berger (2001) Calibration of p Values
for Testing Precise Null Hypotheses, The American Statistician, 55:1, 62-71,
\doi{10.1198/000313001300339950}
}
