% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootcoldist.R
\name{bootcoldist}
\alias{bootcoldist}
\title{Bootstrap colour distance confidence intervals}
\usage{
bootcoldist(vismodeldata, by, boot.n = 1000, alpha = 0.95, raw = FALSE, ...)
}
\arguments{
\item{vismodeldata}{(required) quantum catch colour data.
Can be the result from \code{\link[=vismodel]{vismodel()}}, or \code{\link[=colspace]{colspace()}}. Data may also be
independently calculated quantum catches, in the form of a data frame with
columns representing photoreceptors.}

\item{by}{(required) a numeric or character vector indicating the group to which each row from
the object belongs to.}

\item{boot.n}{number of bootstrap replicates (defaults to 1000)}

\item{alpha}{the confidence level for the confidence intervals (defaults to 0.95)}

\item{raw}{should the full set of bootstrapped distances (equal in length to boot.n)
be returned, instead of the summary distances and CI's? Defaults to FALSE.}

\item{...}{other arguments to be passed to \code{\link[=coldist]{coldist()}}. Must at minimum
include \code{n} and \code{weber}. See \code{\link[=coldist]{coldist()}} for details.}
}
\value{
a matrix including the empirical mean and bootstrapped
confidence limits for dS (and dL if \code{achromatic = TRUE}), or a data.frame
of raw bootstraped dS (and dL if \code{achromatic = TRUE}) values equal in length to boot.n.
}
\description{
Uses a bootstrap procedure to generate confidence intervals
for the mean colour distance between two or more samples of colours
}
\details{
You can customise the type of parallel processing used by this function with
the \code{\link[future:plan]{future::plan()}} function. This works on all operating systems, as well
as high performance computing (HPC) environment. Similarly, you can customise
the way progress is shown with the \code{\link[progressr:handlers]{progressr::handlers()}} functions
(progress bar, acoustic feedback, nothing, etc.)
}
\examples{
\donttest{
# Run the receptor-noise limited model, using the visual phenotype
# of the blue tit
data(sicalis)
vm <- vismodel(sicalis, achromatic = "bt.dc", relative = FALSE)
gr <- gsub("ind..", "", rownames(vm))
bootcoldist(vm, by = gr, n = c(1, 2, 2, 4), weber = 0.1, weber.achro = 0.1)

# Run the same again, though as a simple colourspace model
data(sicalis)
vm <- vismodel(sicalis, achromatic = "bt.dc")
space <- colspace(vm)
gr <- gsub("ind..", "", rownames(space))
bootcoldist(space, by = gr)

# Estimate bootstrapped colour-distances for a more 'specialised' model,
# like the colour hexagon
data(flowers)
vis.flowers <- vismodel(flowers,
  visual = "apis", qcatch = "Ei", relative = FALSE,
  vonkries = TRUE, achromatic = "l", bkg = "green"
)
flowers.hex <- colspace(vis.flowers, space = "hexagon")
pop_group <- c(rep("pop_1", nrow(flowers.hex) / 2), rep("pop_2", nrow(flowers.hex) / 2))
bootcoldist(flowers.hex, by = pop_group)
}

}
\references{
Maia, R., White, T. E., (2018) Comparing colors using visual models.
Behavioral Ecology, ary017 \doi{10.1093/beheco/ary017}
}
