% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_setattr_inplace.R
\name{marker_inplace}
\alias{marker_inplace}
\alias{genotype<-}
\alias{genotype<-.marker}
\alias{genotype<-.ped}
\alias{mutmod<-}
\alias{mutmod<-.marker}
\alias{mutmod<-.ped}
\alias{mutmod<-.list}
\alias{afreq<-}
\alias{afreq<-.marker}
\alias{afreq<-.ped}
\alias{afreq<-.list}
\alias{name<-}
\alias{name<-.marker}
\alias{name<-.ped}
\alias{name<-.list}
\alias{chrom<-}
\alias{chrom<-.marker}
\alias{chrom<-.ped}
\alias{chrom<-.list}
\alias{posMb<-}
\alias{posMb<-.marker}
\alias{posMb<-.ped}
\title{Set marker attributes}
\usage{
genotype(x, ...) <- value

\method{genotype}{marker}(x, id, ...) <- value

\method{genotype}{ped}(x, marker, id, ...) <- value

mutmod(x, ...) <- value

\method{mutmod}{marker}(x, ...) <- value

\method{mutmod}{ped}(x, marker = NULL, ...) <- value

\method{mutmod}{list}(x, marker = NULL, ...) <- value

afreq(x, ...) <- value

\method{afreq}{marker}(x, ...) <- value

\method{afreq}{ped}(x, marker, ...) <- value

\method{afreq}{list}(x, marker, ...) <- value

name(x, ...) <- value

\method{name}{marker}(x, ...) <- value

\method{name}{ped}(x, markers = NULL, ...) <- value

\method{name}{list}(x, markers = NULL, ...) <- value

chrom(x, ...) <- value

\method{chrom}{marker}(x, ...) <- value

\method{chrom}{ped}(x, markers = NULL, ...) <- value

\method{chrom}{list}(x, markers = NULL, ...) <- value

posMb(x, ...) <- value

\method{posMb}{marker}(x, ...) <- value

\method{posMb}{ped}(x, markers = NULL, ...) <- value
}
\arguments{
\item{x}{Either a \code{marker} object, a \code{ped} object or a list of \code{ped} objects.}

\item{...}{Further arguments, not used.}

\item{value}{Replacement value(s).}

\item{id}{The ID label of a single pedigree member.}

\item{marker, markers}{The index or name of a marker (or a vector indicating
several markers) attached to \code{ped}. Used if \code{x} is a \code{ped} object.}
}
\value{
These functions perform in-place modification of \code{x}.
}
\description{
These S3 methods perform in-place modifications of marker attributes. They
work on single marker objects and markers attached to ped objects (or lists
of such). Although these functions will continue to exist, we recommend the
newer alternatives \code{\link[=setGenotype]{setGenotype()}}, \code{\link[=setAfreq]{setAfreq()}}, ... in most cases.
}
\examples{
x = nuclearPed(1)
x = addMarker(x, alleles = 1:2)

# Set genotypes
genotype(x, marker = 1, id = 1) = "1/2"

# Set marker name
name(x, 1) = "M"

# Change allele freqs
afreq(x, "M") = c(`1` = 0.1, `2` = 0.9)

# Set position
chrom(x, "M") = 1
posMb(x, "M") = 123.45

# Check result
m = marker(x, `1` = "1/2", name = "M", afreq = c(`1` = 0.1, `2` = 0.9),
           chrom = 1, posMb = 123.45)
stopifnot(identical(x$MARKERS[[1]], m))

}
\seealso{
Alternative setters (not in-place): \link{marker_setattr}.
Marker attribute getters: \link{marker_getattr}.
}
