% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_match.R
\name{direct_match}
\alias{direct_match}
\title{Direct Match Species Names}
\usage{
direct_match(df, target_df = NULL, source = "original")
}
\arguments{
\item{df}{A tibble containing the species data to be matched.}

\item{target_df}{A tibble representing the threatened species database containing
the reference list of threatened species.}

\item{source}{Character string specifying which database version to use.
Options are:
\itemize{
  \item \code{"original"} (default): Uses the original threatened species database
  \item \code{"updated"}: Uses the updated database with synonyms
}}
}
\value{
A tibble with an additional logical column `direct_match` indicating whether
the name was successfully matched (`TRUE`) or not (`FALSE`).
}
\description{
Performs direct matching of species names against the threatened species database.
Matches binomial names (genus + species), trinomial names (+ infraspecies level 1),
and quaternomial names (+ infraspecies level 2) when applicable.
}
\keyword{internal}
