% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{printMat}
\alias{printMat}
\title{Print a matrix with separators}
\usage{
printMat(
  x,
  digits = 3,
  shave.spaces = TRUE,
  begin = "",
  sep = "  ",
  end = "",
  print = TRUE,
  format = TRUE
)
}
\arguments{
\item{x}{A numeric matrix to print line by line.}

\item{digits}{Positive integer: the number of digits after the decimal comma to round to
(i.e. one less than the number of significant digits).}

\item{shave.spaces}{Logical: if true, removes spaces to ensure compact output; if false, results
in nearly fixed-width output (almost).}

\item{begin}{A character to put at the beginning of each line, usually \code{""}, \code{"("}, or
\code{"c("} (the latter is useful if console output is used in calculations).}

\item{sep}{The column delimiter, usually \code{"  "}, \code{"|"}, \code{"&"} (for LaTeX), or \code{", "}.}

\item{end}{A character to put at the end of each line, usually \code{""} or \code{")"}.}

\item{print}{If \code{TRUE}, outputs the lines of the matrix rows into the console.}

\item{format}{If \code{FALSE}, skips the formatting part.}
}
\value{
The same \code{x} that was passed as the first input.
}
\description{
Print a matrix with separators
}
\examples{
x <- matrix(c(-1234567, 12345.67, 123.4567,
              1.23456, -1.23456e-1, 0,
              1.23456e-4, 1.23456e-2, -1.23456e-6), nrow = 3)
printMat(x)
printMat(x, 2, TRUE, "c(", ", ", ")")  # Ready row vectors
}
