% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrayslicer.R
\name{ArraySlicer}
\alias{ArraySlicer}
\title{Cut slice from array (typically of class \code{power_array})}
\usage{
ArraySlicer(x, slicer = NULL)
}
\arguments{
\item{x}{An array, in most common use cases an array of class
\code{power_array}, but may be any array with named dimensions.}

\item{slicer}{A list whose named elements define at which dimension (the
list element names), at which values (the list element values) a slice is
taken from \code{power_array}. Default NULL returns the unchanged array.}
}
\value{
An array with reduced dimensions as given by \code{slicer}. Note
that, relative to a standard array, some additional attributes are passed
to be used in the functions in package \code{powergrid}
}
\description{
Cut out a slice from an array. The resulting slice may be
single- or multidimensional. The function is intended for arrays of class
"power_array", and makes sure that the resulting array is of class
power_array and keeps and, where needed, updates the object's
attributes. These attributes are needed for various functions in the
powergrid package to work well.
}
\details{
Internally, indexing ([) is used, but the implementation in
ArraySlicer is very flexible allowing for any number of dimensions in any
order in the \code{slicer} argument. The resulting slice is always an
array, also if only one dimension is left. \code{dimnames} are kept
intact.
}
\examples{
sse_pars = list(
  n = seq(from = 20, to = 60, by = 5),
  delta = seq(from = 0.5, to = 1.5, by = 0.2),
  sd = seq(.1, .9, .2),
  alpha = c(.05, .025, .1)) # a 4-dimensional grid
PowFun <- function(n, delta, sd, alpha){
  ptt = power.t.test(n = n/2, delta = delta, sd = sd,
                     sig.level = alpha)
  return(ptt$power)
}
power_array = PowerGrid(pars = sse_pars, fun = PowFun, n_iter = NA)
## cut out a 2-dimensional plane:
ArraySlicer(power_array,
            slicer = list(alpha = .1, sd = .9))
## Note that above, the dimension levels are called as numeric values, so the
## following works as well:
ArraySlicer(power_array,
            slicer = list(alpha = 0.1, sd = 0.9))
## They can be called by their actual character values as well:
ArraySlicer(power_array,
            slicer = list(alpha = '0.1', sd = '0.9'))
## (compare with dimnames(power_array))
## the following does not work:
\dontrun{
ArraySlicer(power_array,
            slicer = list(alpha = '.1', sd = '.9'))
}
##
## Cut out multiple levels from one dimension
ArraySlicer(power_array,
            slicer = list(alpha = .1, sd = c(.9, .7)))
}
\seealso{
\code{\link{PowerGrid}}, \verb{[.power_array} for reducing the dimensions of
an array of class \code{power_array} using [-indexing.
}
\author{
Gilles Dutilh
}
