% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{check_if_non_negative}
\alias{check_if_non_negative}
\title{Check If Non-Negative}
\usage{
check_if_non_negative(
  x,
  allow_na = TRUE,
  arg = rlang::caller_arg(x),
  error_call = rlang::caller_env()
)
}
\arguments{
\item{x}{Input variable to check if it is non-negative number}

\item{allow_na}{Input boolean to determine if \code{NA} or \code{NaN} is allowed.
Default: \code{TRUE}}

\item{arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
The variable itself or an error message if variable is not non-negative
}
\description{
Check if the input variable is a non-negative number
}
\examples{
# No error
input = 0
try(check_if_non_negative(input))

# Error as -5 is not a non-neagtive number
input = -5
try(check_if_non_negative(input))
}
\seealso{
\code{\link[rlang]{caller_arg}}, \code{\link[rlang]{stack}}
 \code{\link[cli]{cli_abort}}
}
