% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{MahalanobisScores-class}
\alias{MahalanobisScores-class}
\alias{SumScores-class}
\alias{FactorScores-class}
\title{An S4 class to represent composite scores based on Mahalanobis distance}
\description{
An S4 class to represent composite scores based on Mahalanobis distance

An S4 class to represent composite scores based on summing

An S4 class to represent composite scores based on (confirmatory) factor analysis
}
\section{Slots}{

\describe{
\item{\code{scores}}{A vector of the final scores}

\item{\code{scoreHistogram}}{A histogram of the final scores}

\item{\code{screePlot}}{A screeplot from the PCA}

\item{\code{loadingGraph}}{A graph of the component loadings}

\item{\code{loadingTable}}{A table of all the component loadings}

\item{\code{pca}}{Prinicipal component analysis results. A list (coercied from princomp output).}

\item{\code{ncomponents}}{The number of components of the PCA to be used.}

\item{\code{CompositeReady}}{The original CompositeReady class object passed in}

\item{\code{scores}}{A vector of the final scores}

\item{\code{scoreHistogram}}{A histogram of the final scores}

\item{\code{transform}}{A character string of the type of transformation applied}

\item{\code{type}}{A character string indicating whether data were summed or averaged}

\item{\code{trans}}{A list of functions to transform data and backtransform it}

\item{\code{systems}}{A list with as many elements as there are systems where
each element is a character vector containing the variable names for
each system.  If all variables belong to one system, a list with one
element that is missing.}

\item{\code{CompositeReady}}{The original CompositeReady class object passed in}

\item{\code{scores}}{A vector of the final scores}

\item{\code{scoreHistogram}}{A histogram of the final scores}

\item{\code{factorScores}}{A data frame with all factor score predictions}

\item{\code{type}}{A character string indicating the type of factor model used}

\item{\code{factors}}{A list with as many elements as there are specific factors,
where each element is a character vector of the variables for
a specific factor}

\item{\code{Fit}}{A fitted model object from lavaan.}

\item{\code{CompositeReady}}{The original CompositeReady class object passed in}
}}

