% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windows.R
\name{GetHomogeneousWindows}
\alias{GetHomogeneousWindows}
\title{Get windows (dataframes) that have the same specified column values for all observations}
\usage{
GetHomogeneousWindows(
  inputted.data,
  window.ID.col.name,
  observation.vals.to.compare
)
}
\arguments{
\item{inputted.data}{A dataframe that needs a column that labels which window each observation belongs to.}

\item{window.ID.col.name}{A string that specifies the column name of the column that provides the window name.}

\item{observation.vals.to.compare}{A vector of strings with each string being the name of a column in the datafarame to look at.}
}
\value{
List where each object is a homogeneous window (dataframe) that has observations sharing the same values for the
observation.vals.to.compare column(s).
}
\description{
For a given dataframe where the windows are specified by a column in the dataframe,
evaluate whether all observations in each window share the same values for
specified columns.
}
\details{
Function takes a single dataframe with each row as observations. This dataframe
needs a column that specifies which window each observation belongs
to. For each window, the observations within the window is evaluated to see
if all observations share the same values for specified columns of the dataframe.
Windows where the specified columns have the same values across all observations
are labeled as "homogeneous" windows and are captured and outputted in a list,
where each element is a window (dataframe). This function uses the
FindHomogeneousWindows() function to determine whether each window is
homogeneous. As the code executes, it outputs number indicating how many
homogeneous windows have been found so far in the inputted.data.
}
\examples{

#Example using a dataframe with 3 windows.

#Windows 20 and 30 are homogeneous if looking at col.two and col.three values.
window.name.column <- c(10, 10, 10, 20, 20, 20, 30, 30, 30, 30)
col.two <- c("a", "a", "a", "a", "a", "a", "a", "a", "a", "a")
col.three <- c(1, 1, 0, 1, 1, 1, 2, 2, 2, 2)

multi.window.data <- data.frame(window.name.column, col.two, col.three)

result <- GetHomogeneousWindows(multi.window.data, "window.name.column", c("col.two", "col.three"))

#As expected, it looks like two windows are homogeneous.
str(result)

#Output the two windows that are homogeneous:

result[[1]]

result[[2]]


}
