% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{effect_plot}
\alias{effect_plot}
\title{Constructs effect plots on for cases when the response (outcome) is a numerical variable and the explanatory (exposure) is a categorical variable.}
\usage{
effect_plot(data, x, y, orientation = "x")
}
\arguments{
\item{data}{A data frame.}

\item{x}{A variable in the data frame.}

\item{y}{A variable in the data frame.}

\item{orientation}{A string indicating the orientation of the bars.}
}
\value{
An error bars plot, for example, those to show the effects of a categorical variable
on a numerical variable.
}
\description{
\code{effect_plot} constructs plots with error bars on which the upper and lower limits
of the bars are given by the variables \code{CI_high} and \code{CI_low}, respectively.
}
\examples{
data(Fentress)
require(dplyr, quietly = TRUE)
require(sjlabelled, quietly = TRUE)

pain_cis <- Fentress |>
  gen_bst_df(pain ~ group)
names(pain_cis)[1] = "Mean"
pain_cis = pain_cis |>
  var_labels(Mean = "Pain reduction")

pain_cis |>
  effect_plot(x = Cohort, y = Mean)
}
