% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{missChk}
\alias{missChk}
\title{missChk}
\usage{
missChk(
  data,
  use = NULL,
  exclude = NULL,
  type = c("report", "seq"),
  maxpat = 15,
  maxcomb = 25,
  excl1pat = TRUE,
  sortpatterns = TRUE,
  prednmiss = FALSE,
  omitpred = NULL,
  baselabel = NULL,
  ...
)
}
\arguments{
\item{data}{data frame or table to analyze}

\item{use}{a formula or character vector specifying which variables to consider if not all those in \code{data}}

\item{exclude}{a formula or character vector specifying which variables to exclude from consideration}

\item{type}{specify \code{'seq'} to return a summary of sequential exclusions rather than produce a report}

\item{maxpat}{maximum number of missing data patterns allowed when counting occurrences of all combinations of variables' \code{NA}s}

\item{maxcomb}{maximum number of combinations for which to produce a combination dot plot}

\item{excl1pat}{set to \code{FALSE} to not list distinct combinatons that only occur for one observation}

\item{sortpatterns}{set to \code{FALSE} to not sort patterns in decreasing frequency of missingness}

\item{prednmiss}{set to \code{TRUE} to use ordinal regression to predict the number of missing variables on an observation from the values of all the non-missing variables}

\item{omitpred}{a formula or character vector specifying a list of predictors not to use when predicting number of missing variables}

\item{baselabel}{base label for Quarto tabs made with \code{\link[=maketabs]{maketabs()}}}

\item{...}{passed to \code{\link[Hmisc:combplotp]{Hmisc::combplotp()}}}
}
\value{
nothing; outputs Quarto/RMarkdown text and tabs for a full report section
}
\description{
Produce a Report Section Detailing Missing Values in a Dataset
}
\details{
Quantifies frequencies of missing observations on a variable and missing variables on an observaton and produces variables tables and (depending on the number of \code{NA}s) multiple graphic displays in Quarto tabs.  The results are best understood by referring to \href{https://hbiostat.org/rflow/case.html#missing-data/}{this}.
}
\examples{
\dontrun{
missChk(mydata)
}
}
\author{
Frank Harrell
}
