% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qryflow.R
\name{qryflow_parse}
\alias{qryflow_parse}
\title{Parse a SQL workflow into tagged chunks}
\usage{
qryflow_parse(sql)
}
\arguments{
\item{sql}{A file path to a SQL workflow file, or a character vector containing SQL lines.}
}
\value{
An object of class \code{qryflow_workflow}, which is a structured list of SQL chunks and
metadata.
}
\description{
\code{qryflow_parse()} reads a SQL workflow file or character vector and parses it into
discrete tagged chunks based on \verb{@query}, \verb{@exec}, and other custom markers.
}
\details{
This function is used internally by \code{\link[=qryflow_run]{qryflow_run()}}, but can also be used directly to
preprocess or inspect the structure of a SQL workflow.
}
\examples{
filepath <- example_sql_path("mtcars.sql")

parsed <- qryflow_parse(filepath)
}
\seealso{
\code{\link[=qryflow]{qryflow()}}, \code{\link[=qryflow_run]{qryflow_run()}}, \code{\link[=qryflow_execute]{qryflow_execute()}}
}
