% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{changes_by}
\alias{changes_by}
\title{Change Scores from Numeric Data by Group}
\usage{
changes_by(data, vrb.nm, grp.nm, n, undefined = NA, suffix)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
groups.}

\item{n}{integer vector with length 1. Specifies how the change score is
calculated. If \code{n} is positive, then the change score is calculated
from lead - original; if \code{n} is negative, then the change score is
calculated from original - lag. The magnitude of \code{n} determines how
many rows are shifted for the lead/lag within the calculation. See details
of \code{\link{shifts_by}}.}

\item{undefined}{atomic vector with length 1 (probably makes sense to be the
same typeof as \code{x}). Specifies what to insert for undefined values
after the shifting takes place. See details of \code{\link{shifts_by}}.}

\item{suffix}{character vector of length 1 specifying the string to append to
the end of the colnames of the return object. The default depends on the
\code{n} argument: 1) if \code{n} < 0, then \code{suffix} =
\code{paste0("_hgw", -n)}, 2) if \code{n} > 0, then \code{suffix} =
\code{paste0("_hdw", +n)}, 3) if \code{n} = 0, then \code{suffix} = "".}
}
\value{
data.frame of change scores by group with colnames specified by
  \code{paste0(vrb.nm, suffix)}.
}
\description{
\code{changes_by} creates change scores (aka difference scores) from numeric
data separately for each group. It is assumed that the data is already sorted
within each group by time such that the first row for that group is earliest
in time and the last row for that group is the latest in time.
}
\details{
It is recommended to use \code{L} when specifying \code{n} to prevent
problems with floating point numbers. \code{shifts_by} tries to circumvent
this issue by a call to \code{round} within \code{shifts_by} if \code{n} is
not an integer; however that is not a complete fail safe. The problem is that
\code{as.integer(n)} implicit in \code{shifts_by} truncates rather than
rounds. See details of \code{\link{shifts_by}}.
}
\examples{
changes_by(data = ChickWeight, vrb.nm = c("weight","Time"), grp.nm = "Chick", n = -1L)
changes_by(data = mtcars, vrb.nm = c("disp","mpg"), grp.nm = c("vs","am"), n = 1L)
changes_by(data = as.data.frame(CO2), vrb.nm = c("conc","uptake"),
   grp.nm = c("Type","Treatment"), n = 2L) # multiple grouping columns
}
\seealso{
\code{\link{change_by}}
   \code{\link{changes}}
   \code{\link{change}}
   \code{\link{shifts_by}}
}
