% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_read.R
\name{rtf_read_figure}
\alias{rtf_read_figure}
\title{Read Figures into Binary Files}
\usage{
rtf_read_figure(file)
}
\arguments{
\item{file}{A character vector of figure file paths.}
}
\value{
a list of binary data vector returned by \code{readBin}
}
\description{
Supported format is listed in \code{r2rtf:::fig_format()}.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Read PNG figures into binary file using \code{lapply} and \code{readBin}
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
\dontrun{

# Read in PNG file in binary format
file <- tempfile("figure", fileext = ".png")
png(file)
plot(1:10)
dev.off()


rtf_read_figure(file)

# Read in EMF file in binary format
library(devEMF)
file <- tempfile("figure", fileext = ".emf")
emf(file)
plot(1:10)
dev.off()

rtf_read_figure(file)
}
}
