% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{logistic}
\alias{logistic}
\title{Logistic regression}
\usage{
logistic(
  dataset,
  rvar,
  evar,
  lev = "",
  int = "",
  wts = "None",
  check = "",
  form,
  ci_type,
  data_filter = "",
  arr = "",
  rows = NULL,
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset}

\item{rvar}{The response variable in the model}

\item{evar}{Explanatory variables in the model}

\item{lev}{The level in the response variable defined as _success_}

\item{int}{Interaction term to include in the model}

\item{wts}{Weights to use in estimation}

\item{check}{Use "standardize" to see standardized coefficient estimates. Use "stepwise-backward" (or "stepwise-forward", or "stepwise-both") to apply step-wise selection of variables in estimation. Add "robust" for robust estimation of standard errors (HC1)}

\item{form}{Optional formula to use instead of rvar, evar, and int}

\item{ci_type}{To use the profile-likelihood (rather than Wald) for confidence intervals use "profile". For datasets with more than 5,000 rows the Wald method will be used, unless "profile" is explicitly set}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{arr}{Expression to arrange (sort) the data on (e.g., "color, desc(price)")}

\item{rows}{Rows to select from the specified dataset}

\item{envir}{Environment to extract data from}
}
\value{
A list with all variables defined in logistic as an object of class logistic
}
\description{
Logistic regression
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/logistic.html} for an example in Radiant
}
\examples{
logistic(titanic, "survived", c("pclass", "sex"), lev = "Yes") \%>\% summary()
logistic(titanic, "survived", c("pclass", "sex")) \%>\% str()
}
\seealso{
\code{\link{summary.logistic}} to summarize the results

\code{\link{plot.logistic}} to plot the results

\code{\link{predict.logistic}} to generate predictions

\code{\link{plot.model.predict}} to plot prediction output
}
