% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_norm_size.R
\name{one_norm_size}
\alias{one_norm_size}
\title{Sample Size or Power Calculation for One-Sample Normal Mean Test}
\usage{
one_norm_size(mu, mu0, sd, alpha, beta = NULL, n = NULL)
}
\arguments{
\item{mu}{Numeric. True mean.}

\item{mu0}{Numeric. Null hypothesis mean.}

\item{sd}{Numeric. Standard deviation.}

\item{alpha}{Numeric. Type I error rate.}

\item{beta}{Numeric (optional). Type II error rate. Required for sample size calculation.}

\item{n}{Integer (optional). Sample size. Required for power calculation.}
}
\value{
Numeric. Returns sample size (if \code{beta} is given), or power (if \code{n} is given).
}
\description{
Calculates sample size or power for a two-sample normal mean test.
}
\note{
Only one of \code{beta} (for sample size calculation) or \code{n} (for power calculation) should be specified.

Required arguments:
\itemize{
\item For sample size: \code{"mu"}, \code{"mu0"}, \code{"sd"}, \code{"alpha"}, \code{"beta"}
\item For power: \code{"mu"}, \code{"mu0"}, \code{"sd"}, \code{"alpha"}, \code{"n"}
}
}
\examples{
# Sample size
one_norm_size(mu = 2, mu0 = 1.5, sd = 1,
              alpha = 0.05, beta = 0.2)

# Power
one_norm_size(mu = 2, mu0 = 1.5, sd = 1,
              alpha = 0.05, n = 32)

}
