% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow-archive-subject.R
\name{install_subject}
\alias{install_subject}
\title{Install a subject from the internet, a zip file or a directory}
\usage{
install_subject(
  path = ".",
  ask = interactive(),
  overwrite = FALSE,
  backup = TRUE,
  use_cache = TRUE,
  dry_run = FALSE,
  force_project = NA,
  force_subject = NA,
  ...
)
}
\arguments{
\item{path}{path to subject archive, can be a path to directory, a zip file,
or an internet address (must starts with \code{'http'}, or \code{'ftp'})}

\item{ask}{when \code{overwrite} is false, whether to ask the user if subject
exists; default is true when running in interactive session; users will be
prompt with choices; if \code{ask=FALSE} and \code{overwrite=FALSE}, then
the process will end with a warning if the subject exists.}

\item{overwrite}{whether to overwrite existing subject, see argument
\code{ask} and \code{backup}}

\item{backup}{whether to back-up the subject when overwriting the data;
default is true, which will rename the old subject folders instead of
removing; set to true to remove existing subject.}

\item{use_cache}{whether to use cached extraction directory; default is
true. Set it to \code{FALSE} if you want a clean installation.}

\item{dry_run}{whether to dry-run the process instead of actually installing;
this rehearsal can help you see the progress and prevent you from losing data}

\item{force_project, force_subject}{force set the project or subject;
will raise a warning as this might mess up some pipelines}

\item{...}{passed to \code{\link[utils]{download.file}}}
}
\description{
Install a subject from the internet, a zip file or a directory
}
\examples{


\dontrun{

install_subject("DemoSubject")

}

}
