% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy-data2d.R
\name{Data2D}
\alias{Data2D}
\alias{get_data2d_data}
\alias{get_data2d_value}
\alias{put_data2d_data}
\alias{put_data2d_value}
\alias{read_data2d_value}
\alias{write_data2d_value}
\title{Read and write Data2D data}
\usage{
get_data2d_data(x, z, dimension, db = default_db())

get_data2d_value(x, z, dimension, db = default_db())

put_data2d_data(values, x, z, dimension, db = default_db())

put_data2d_value(value, x, z, dimension, db = default_db())

read_data2d_value(rawvalue)

write_data2d_value(value)
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{values}{A (named) list of Data2D values. If \code{x} is missing, the names
of \code{values} will be taken as the keys.}

\item{value}{A Data2D value.}

\item{rawvalue}{A raw vector.}
}
\value{
\code{get_data2d_value()} returns a Data2D value. \code{get_data2d_data()}
returns a named list of Data2D values. Data2D values are lists containing
two elements. The \code{height_map} element is a 16x16 matrix containing height
data. The \code{biome_map} element is a 16x16 matrix containing biome data.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Data2D data (tag 45) stores information about surface heights and biomes in a
chunk. Data2D data is 768 bytes long and consists of a 256 int16s (heights)
followed by 256 uint8s (biomes). The game no longer uses it after 1.18.
\itemize{
\item \code{get_data2d_value()} and \code{get_data2d_data()} load Data2D
data from \code{db}. \code{get_data2d_value()} loads data for a single chunk,
and \code{get_data2d_data()} loads data for multiple chunks.
\item \code{put_data2d_value()} and \code{put_data2d_data()} store Data2D
data into \code{db}.
\item \code{write_data2d_value()} encodes Data2D data into a raw vector.
\code{read_data2d_value()} decodes binary Data2D data.
}
}
\seealso{
Data3D
}
\keyword{internal}
