% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbt-rnbt.R
\name{rnbt}
\alias{rnbt}
\alias{read_rnbt}
\alias{read_rnbt_once}
\alias{write_rnbt}
\alias{from_rnbt}
\alias{to_rnbt}
\title{Raw Named Binary Tag Format}
\usage{
read_rnbt(rawvalue, format = c("little", "big", "network", "network_big"))

read_rnbt_once(rawvalue, format = c("little", "big", "network", "network_big"))

write_rnbt(x, format = c("little", "big", "network", "network_big"))

from_rnbt(x)

to_rnbt(x)
}
\arguments{
\item{rawvalue}{A \code{raw} vector}

\item{format}{A character string specifying which binary NBT format to use.}

\item{x}{An object}
}
\description{
\code{rnbt} is a recursive, intermediate data structure that closely
resembles how NBT data is encoded.
}
\details{
\itemize{
\item \code{read_rnbt()} converts a \code{raw} vector to \code{rnbt} data.
\item \code{write_rnbt()} converts \code{rnbt} data to a \code{raw} vector
\item \code{from_rnbt()} converts \code{rnbt} data to \code{nbt} data.
\item \code{to_rnbt()} converts \code{nbt} data to \code{rnbt} data.
}
}
\keyword{internal}
