% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defuzzify.R
\name{defuzzify}
\alias{defuzzify}
\title{Defuzzify a fuzzy classification}
\usage{
defuzzify(mem, segmentation)
}
\arguments{
\item{mem}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} of one layer. Degree of
membership in a fuzzy classification.}

\item{segmentation}{single-layer \link[terra:SpatRaster-class]{terra::SpatRaster} with integer
values.}
}
\value{
Logical \link[terra:SpatRaster-class]{terra::SpatRaster} of the same dimensions as \code{mem},
where each pixel value represents the binary version of \code{mem} after
applying the regional defuzzification procedure.
}
\description{
Converts fuzzy membership values into a binary classification using a
regional approach that preserves aggregation consistency between the fuzzy
and binary representations.
}
\details{
The conversion is applied within segments defined by \code{segmentation},
ensuring that, in each segment, the aggregated Boolean result matches the
aggregated fuzzy value. This approach is well suited for converting subpixel
estimates, such as gap fraction, into binary outputs.
}
\note{
This method is also available in the HSP software package. See
\code{\link[=hsp_compat]{hsp_compat()}}.
}
\examples{
\dontrun{
caim <- read_caim()
r <- caim$Blue
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)

path <- system.file("external/example.txt", package = "rcaiman")
sky_cie <- read_sky_cie(gsub(".txt", "", path), z, a)

sky_above <- ootb_sky_above(sky_cie$model$rr$sky_points, z, a, sky_cie)

ratio <- r / sky_above$dn_raster
ratio <- normalize_minmax(ratio, 0, 1, TRUE)
plot(ratio)
g <- sky_grid_segmentation(z, a, 10)
bin2 <- defuzzify(ratio, g)
plot(bin2) # unsatisfactory results due to light conditions
}
}
