% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_sun_angles.R
\name{estimate_sun_angles}
\alias{estimate_sun_angles}
\title{Estimate sun angular coordinates}
\usage{
estimate_sun_angles(
  r,
  z,
  a,
  bin,
  g,
  angular_radius_sun = 30,
  method = "assume_obscured"
)
}
\arguments{
\item{r}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} of one layer. Typically the blue
band of a canopy image.}

\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{bin}{logical \link[terra:SpatRaster-class]{terra::SpatRaster} of one layer. Binary image where
\code{TRUE} marks candidate sky pixels. Typically the output of
\code{\link[=binarize_with_thr]{binarize_with_thr()}}.}

\item{g}{single-layer \link[terra:SpatRaster-class]{terra::SpatRaster} with integer values. Sky
segmentation map produced by \code{\link[=sky_grid_segmentation]{sky_grid_segmentation()}}.}

\item{angular_radius_sun}{numeric vector of length one. Maximum angular
radius (in degrees) used to define the circumsolar region.}

\item{method}{character vector of length one. Estimation mode:
\code{"assume_obscured"} (default) or \code{"assume_veiled"}.}
}
\value{
Named numeric vector of length two, with names \code{z} and \code{a},
representing the sun’s zenith and azimuth angles (in degrees).
}
\description{
Estimates the sun’s zenith and azimuth angles (deg) from a canopy
hemispherical photograph, using either direct detection of the solar disk or
indirect cues from the circumsolar region.
}
\details{
This function can operate under two alternative assumptions for
estimating the sun position:

\describe{
\item{Veiled sun}{The solar disk is visible or partially obscured; the
position is inferred from localized brightness peaks.}
\item{Obscured sun}{The solar disk is not visible; the position is inferred
from radiometric and spatial cues aggregated over the circumsolar region.}
}

When \code{method = "assume_veiled"}, \code{g} and \code{angular_radius_sun} are ignored.
Estimates refer to positions above the horizon; therefore, estimated angles
may require further manipulation if the photograph was acquired under
crepuscular light.
}
\note{
A scientific article presenting and validating this method is currently
under preparation.
}
\examples{
\dontrun{
caim <- read_caim()
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
m <- !is.na(z)
r <- caim$Blue

bin <- binarize_by_region(r, ring_segmentation(z, 15), "thr_isodata") &
  select_sky_region(z, 0, 88)

g <- sky_grid_segmentation(z, a, 10)
sun_angles <- estimate_sun_angles(r, z, a, bin, g,
                                  angular_radius_sun = 30)
row_col <- row_col_from_zenith_azimuth(z, a,
                                       sun_angles["z"],
                                       sun_angles["a"])
plot(caim$Blue)
points(row_col[1,2], nrow(caim) - row_col[1,1], col = "yellow",
       pch = 8, cex = 3)
}
}
