% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{p2pTest}
\alias{p2pTest}
\title{Point to point test of SPD}
\usage{
p2pTest(x, p1 = NA, p2 = NA, interactive = TRUE, plot = FALSE)
}
\arguments{
\item{x}{result of \code{\link[rcarbon]{modelTest}} with raw=TRUE.}

\item{p1}{calendar year (in BP) of start point.}

\item{p2}{calendar year (in BP) of end point.}

\item{interactive}{if set to TRUE enables an interactive selection of p1 and p2 from a graphical display of the SPD. Disabled when \code{p1} and \code{p2} are defined.}

\item{plot}{if set to TRUE the function plots the location of p1 and p2 on the SPD. Default is FALSE.}
}
\value{
A list with: the BP dates for the two points and the p-value obtained from a two-sided test.
}
\description{
Test for evaluating the difference in the summed probability values associated with two points in time.
}
\details{
The function compares observed differences in the summed probability values associated with two points in time against a distribution of expected values under the null hypothesis defined with the \code{\link[rcarbon]{modelTest}} function. The two points can be specified manually (assigning BP dates to the arguments \code{p1} and \code{p2}) or interactively (clicking on a SPD plot). Note that \code{\link[rcarbon]{modelTest}} should be executed setting the argument \code{raw} to \code{TRUE} (default is \code{FALSE}).
}
\examples{
## Example with Younger Dryas period Near East, including site bins
\dontrun{
data(emedyd)
caldates <- calibrate(x=emedyd$CRA, errors=emedyd$Error, normalised=FALSE)
bins <- binPrep(sites=emedyd$SiteName, ages=emedyd$CRA, h=50)
nsim=10 #toy example
expnull <- modelTest(caldates, errors=emedyd$Error, bins=bins, nsim=nsim, runm=50,
timeRange=c(16000,9000), model="exponential", datenormalised=FALSE, raw=TRUE)
p2pTest(x=expnull,p1=13000,p2=12500) #non-interactive mode
p2pTest(x=expnull) #interactive mode
}
}
\references{
Edinborough, K., Porcic, M., Martindale, A., Brown, T.J., Supernant, K., Ames, K.M., (2017). Radiocarbon test for demographic events in written and oral history. PNAS 201713012. doi:10.1073/pnas.1713012114
}
\seealso{
\code{\link[rcarbon]{modelTest}}.
}
