% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_rcdf_as.R
\name{write_rcdf_csv}
\alias{write_rcdf_csv}
\title{Write RCDF data to CSV files}
\usage{
write_rcdf_csv(data, path, ..., parent_dir = NULL)
}
\arguments{
\item{data}{A valid RCDF object.}

\item{path}{The base output directory.}

\item{...}{Additional arguments passed to \code{write.csv()}.}

\item{parent_dir}{Optional subdirectory under \code{path} to group CSV files.}
}
\value{
Invisibly returns \code{NULL}. Files are written to disk.
}
\description{
Writes each table in the RCDF object as a separate \code{.csv} file.
}
\examples{
dir <- system.file("extdata", package = "rcdf")
rcdf_path <- file.path(dir, 'mtcars.rcdf')
private_key <- file.path(dir, 'sample-private-key.pem')

rcdf_data <- read_rcdf(path = rcdf_path, decryption_key = private_key)
temp_dir <- tempdir()

write_rcdf_csv(data = rcdf_data, path = temp_dir)

unlink(temp_dir, force = TRUE)
}
\seealso{
\link[rcdf]{write_rcdf_as}
}
