% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kMeans}
\alias{kMeans}
\title{Run a k-means clustering analysis}
\usage{
kMeans(data, clusters)
}
\arguments{
\item{data}{A matrix of data values}

\item{clusters}{An integer specifying the number of clusters}
}
\value{
A list with cluster assignments
}
\description{
Run a k-means clustering analysis, returning a list of cluster assignments
}
\details{
This function performs a k-means clustering analysis on the given data set.
}
\examples{
x <- rbind(matrix(rnorm(100, sd = 0.3), ncol = 2),
           matrix(rnorm(100, mean = 1, sd = 0.3), ncol = 2))
colnames(x) <- c("x", "y")
cl <- kMeans(x, 2)

data(trees, package="datasets")
cl2 <- kMeans(t(trees),3)
}
