% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{randomForest}
\alias{randomForest}
\title{Run a Random Forest classificatio}
\usage{
randomForest(dataset, labels, pct = 0.3, nclasses = 7L, ntrees = 10L)
}
\arguments{
\item{dataset}{A matrix of explanatory variables, i.e. \dQuote{features}}

\item{labels}{A vector of the dependent variable as integer values, i.e. \dQuote{labels}}

\item{pct}{A numeric value for the percentage of data to be retained for the test set}

\item{nclasses}{An integer value for the number of a distinct values in \code{labels}}

\item{ntrees}{An integer value for the number of trees}
}
\value{
A list object
}
\description{
Run a Random Forest Classifier
}
\details{
This function performs a Random Forest classification on a subset of the
standard \sQuote{covertype} data set
}
\examples{
data(covertype_small)                         # see help(covertype_small)
res <- randomForest(covertype_small[-55,],    # features (already transposed)
                    covertype_small[55,],     # labels now in [0, 6] range
                    0.3)                      # percentage used for testing
str(res)  # accuracy varies as method is randomized but not seed set here
}
\seealso{
covertype_small
}
