% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_sens_bw.R
\name{rd_sens_bw}
\alias{rd_sens_bw}
\title{Bandwidth Sensitivity Simulation for Regression Discontinuity}
\usage{
rd_sens_bw(object, bws)
}
\arguments{
\item{object}{An object returned by \code{rd_est} or \code{rd_impute}.}

\item{bws}{A positive numeric vector of the bandwidths for refitting an \code{rd} object.}
}
\value{
\code{rd_sens_bw} returns a dataframe containing the estimate \code{est} and standard error \code{se} 
  for each supplied bandwidth and for the Imbens-Kalyanaraman (2012) optimal bandwidth, \code{bw}, 
  and for each supplied approach, \code{model}.  Approaches are either user
  specified (\code{"usr"}) or based on the optimal bandwidth (\code{"origin"}).
}
\description{
\code{rd_sens_bw} refits the supplied model with varying bandwidths. 
All other aspects of the model are held constant.
}
\examples{
set.seed(12345)
x <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * x + 3 * cov + 10 * (x >= 0) + rnorm(1000)
rd <- rd_est(y ~ x | cov, t.design = "geq")
rd_sens_bw(rd, bws = seq(.1, 1, length.out = 5))
}
\references{
Imbens, G., Kalyanaraman, K. (2012). 
  Optimal bandwidth choice for the regression discontinuity estimator. 
  The Review of Economic Studies, 79(3), 933-959.
  \url{https://academic.oup.com/restud/article/79/3/933/1533189}.
}
