% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilsRIVerification.R
\name{verifyRI}
\alias{verifyRI}
\title{Verify Reference Intervals}
\usage{
verifyRI(
  RIdata,
  RIcand,
  RIperc = c(0.025, 0.975),
  UMprop = 0.9,
  pointEst = c("fullDataEst", "medianBS"),
  printResults = TRUE,
  generatePlot = TRUE,
  Scale = c("original", "transformed", "splitXAxis"),
  xlab = NULL,
  title = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{RIdata}{specifying the RI of the local population: (1) (object) of class \code{RWDRI} or (2) (numeric) representation of reference limits}

\item{RIcand}{specifying the RI that needs to be verified: (1) (object) of class \code{RWDRI} or (2) (numeric) representation of reference limits}

\item{RIperc}{(numeric) value specifying the percentiles, which define the reference interval (default c(0.025, 0.975))}

\item{UMprop}{(numeric) specifying the width of the confidence interval approximated by the uncertainty margins (default 0.9)}

\item{pointEst}{(character) specifying the point estimate determination: (1) using the full dataset ("fullDataEst"),
(2) calculating the median model from the bootstrap samples ("medianBS"), (2) works only if NBootstrap > 0}

\item{printResults}{(logical) if TRUE, results are printed in the console.}

\item{generatePlot}{(logical) if TRUE, a plot is generated.}

\item{Scale}{(character) specifying the scale of the plot: (1) "original", (2) "transformed", (3) "splitXAxis"}

\item{xlab}{(character) optional x-axis label for the plot}

\item{title}{(character) optional title for the plot}

\item{verbose}{(logical) specifying if additional warning messages are printed}

\item{...}{(list) specifying non-default parameters for the calculation of the margins}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{		(list) containing the verification results
}\if{html}{\out{</div>}}
}
\description{
This function verifies the reference intervals based on the provided data.
}
\examples{
\dontrun{

# standard usecase: 
# comparison of the RI estimated from the local population with a numeric candidate
# RI from, e.g., literature
RIdata <- findRI(testcase1)
RIcand <- c(10, 20)
verifyRI(RIdata, RIcand, RIperc = c(0.025, 0.975))

# Test if two refineR models are equivalent with stricter criteria, i.e., larger n
model1 <- list(Mu = 20, Sigma = 11, Shift = 8, Lambda = 1,
							Method = "manual", roundingBase = NA)
model2 <- list(Mu = 3.41, Sigma = 0.504, Shift = 1, Lambda = 0.06,
							Method = "manual", roundingBase = NA)
class(model1) <- class(model2) <- "RWDRI"
verifyRI(RIdata = model1, RIcand = model2, UMprop = 0.95, n = 1e4)

# verify two numeric RIs
verifyRI(RIdata = c(2.4, 28), RIcand = c(3.1, 29.75))
}

}
\author{
Matthias Beck \email{matthias.beck.mb1@roche.com}
}
