% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tie_data}
\alias{tie_data}
\title{Tie-Oriented Relational Event History}
\format{
\code{tie_data} is a list object containing the following objects:
\describe{
   \item{\code{edgelist}}{a \code{data.frame} with the raw simulated edgelist. The columns of the \code{data.frame} are:
           \describe{
               \item{\code{time}}{the timestamp indicating the time at which each event occurred}
               \item{\code{actor1}}{the actor that generated the relational event}
               \item{\code{actor2}}{the actor that received the relational event}
           }}
   \item{\code{seed}}{the seed value used in \code{remulate::remulateTie()} for generating the event sequence}
   \item{\code{true.pars}}{ a vector containing the values of the parameters used in the generation of the event sequence}
    }
}
\usage{
data(tie_data)
}
\description{
A randomly generated sequence of relational events with 5 actors and 100 events. The event sequence is generated by following a tie-oriented modeling approach (for more information run on console \code{help(topic = remulateTie, package = "remulate")} or \code{?remulate::remulateTie}).
}
\examples{

# (1) load the data into the workspace
data(tie_data)

# (2) process event sequence with \code{remify}
tie_reh <- remify::remify(edgelist = tie_data$edgelist, model = "tie")

# (3) define linear predictor and claculate stastistcs with \code{remstats} package

## linear predictor
tie_model <- ~ 1 + remstats::indegreeSender() + remstats::inertia() + remstats::reciprocity() 

## calculate statistics
tie_reh_stats <- remstats::remstats(reh = tie_reh, tie_effects = tie_model)

# (4) estimate model using method = "MLE" and print out summary

## estimate model 
mle_tie <- remstimate::remstimate(reh = tie_reh, stats = tie_reh_stats, method = "MLE")

## print out a summary of the estimation
summary(mle_tie)

}
\keyword{datasets}
