test_that("lognormal distribution works", {
  set.seed(1337L)
  dist <- dist_lognormal()
  params <- list(meanlog = 1, sdlog = 2)
  x <- dist$sample(100L, with_params = params)

  expect_silent(fit(dist, x))
  expect_identical(dist$get_type(), "continuous")
  expect_density(dist, dlnorm, params, x)
  expect_probability(dist, plnorm, params, x)
  expect_quantile(dist, qlnorm, params)
  expect_identical(dist$is_in_support(x), rep_len(TRUE, length(x)))
  expect_diff_density(dist, x, params)
  expect_diff_density(dist, x, list(meanlog = 3, sdlog = 5))
  expect_diff_probability(dist, x, params)
  expect_diff_probability(dist, x, list(meanlog = 3, sdlog = 5))
  expect_tf_logprobability(dist, params, x, x + 1.0)
  expect_tf_logprobability(dist, params, 0, x)
  expect_tf_logprobability(dist, params, x, Inf)
  expect_tf_logprobability(dist, params, -Inf, x)

  expect_tf_fit(dist, params, I_POSITIVE_REALS)
})
