% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_install.R
\name{ee_install}
\alias{ee_install}
\title{Create an isolated Python virtual environment with all rgee dependencies.}
\usage{
ee_install(
  py_env = "rgee",
  earthengine_version = ee_version(),
  python_version = "3.13",
  confirm = interactive()
)
}
\arguments{
\item{py_env}{Character. The name, or full path, of the Python environment
to be used by rgee.}

\item{earthengine_version}{Character. The Earth Engine Python API version
to install. By default \code{rgee::ee_version()}.}

\item{python_version}{Only Windows users. The Python version to be used
in this conda environment. If set to NULL, the default Python package will be used.
For example, you can specify python_version = "3.6" to request the creation of the
conda environment with a copy of Python 3.6.}

\item{confirm}{Logical. Confirm before restarting R?.}
}
\value{
No return value, called for installing non-R dependencies.
}
\description{
Create an isolated Python virtual environment with all rgee dependencies.
\code{ee_install} realize the following six (6) tasks:
\describe{
\item{1. }{If you do not have a Python environment installed, it will display
an interactive menu to install \href{https://docs.conda.io/en/latest/miniconda.html}{Miniconda}
(a free minimal installer for conda).}
\item{2. }{If it exists, the previous Python environment specified in
the \code{py_env} argument will be deleted.}
\item{3. }{Create a new Python environment (See \code{py_env}) argument.}
\item{4. }{Set the environment variable EARTHENGINE_PYTHON and EARTHENGINE_ENV.
It is used to define RETICULATE_PYTHON when the library is loaded. See this
\href{https://rstudio.github.io/reticulate/articles/versions.html}{article}
for further details.}
\item{5. }{Install rgee Python dependencies. Using \code{reticulate::py_install}.}
\item{6. }{Interactive menu to confirm if restart the R session to see changes.}
}
}
\examples{
\dontrun{
library(rgee)
# ee_install()
}
}
\seealso{
Other ee_install functions: 
\code{\link{ee_install_set_pyenv}()},
\code{\link{ee_install_upgrade}()}
}
\concept{ee_install functions}
