% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{setup_juliaBUGS}
\alias{setup_juliaBUGS}
\title{Setup Julia Environment for JuliaBUGS}
\usage{
setup_juliaBUGS(
  extra_packages = NULL,
  verify_package = TRUE,
  install_from_dev = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{extra_packages}{Character vector of additional Julia packages to install and load.
Defaults to \code{NULL}, meaning only the core packages are handled.}

\item{verify_package}{Logical; if \code{TRUE}, verifies and installs missing core packages. Default is \code{TRUE}.}

\item{install_from_dev}{Logical; if \code{TRUE}, installs \code{JuliaBUGS} from its development repository. Default is \code{FALSE}.}

\item{verbose}{Logical. If \code{FALSE} will ommit any message from the function to indicate
the setup progress.}

\item{...}{Additional arguments passed to \code{JuliaCall::julia_setup()}, such as \code{installJulia = TRUE}.}
}
\value{
Invisibly returns \code{NULL}. The function is called for its side effects.
}
\description{
Installs and loads the required Julia packages to use JuliaBUGS via JuliaCall in R.
}
\details{
This function checks whether the core Julia packages needed for running \code{JuliaBUGS} are installed,
installs any missing ones, and loads them into the current Julia session.
Optionally, additional Julia packages can be installed and loaded by specifying them via \code{extra_packages}.

The core Julia packages installed (if needed) are:
\itemize{
\item Serialization
\item LogDensityProblemsAD
\item ReverseDiff
\item AdvancedHMC
\item AbstractMCMC
\item LogDensityProblems
\item MCMCChains
\item DataFrames
\item JuliaBUGS
}

After installation, all these packages are loaded in the Julia session using \code{using}.
Any additional packages provided via \code{extra_packages} are also installed and loaded.
}
\examples{
\dontrun{
# Setup Julia with core packages only
setup_juliaBUGS()

# Setup Julia with additional packages
setup_juliaBUGS(extra_packages = c("Distributions", "Turing"))
}

}
\seealso{
\code{\link[JuliaCall]{julia_install_package_if_needed}}, \code{\link[JuliaCall]{julia_eval}}
}
