% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{read10XFiles}
\alias{read10XFiles}
\title{Read 10X cellranger files (matrix, barcodes and features) into R session}
\usage{
read10XFiles(
  matrixPath,
  barcodesPath,
  featuresPath,
  sampleName = NULL,
  geneCol = 2,
  cellCol = 1,
  isATAC = FALSE,
  returnList = FALSE
)
}
\arguments{
\item{matrixPath}{Character string, path to the matrix MTX file. Can be
gzipped.}

\item{barcodesPath}{Character string, path to the barcodes TSV file. Can be
gzipped.}

\item{featuresPath}{Character string, path to the features TSV file. Can be
gzipped.}

\item{sampleName}{Character string attached as a prefix to the cell barcodes
loaded from the barcodes file. Default \code{NULL} does not add any prefix.
Useful when users plan to merge multiple samples into one matrix and need
to avoid duplicated cell barcodes from different batches.}

\item{geneCol}{An integer indicating which column in the features file to
extract as the feature identifiers. Default \code{2}.}

\item{cellCol}{An integer indicating which column in the barcodes file to
extract as the cell identifiers. Default \code{1}.}

\item{isATAC}{Logical, whether the data is for ATAC-seq. Default
\code{FALSE}. If \code{TRUE}, feature identifiers will be generated by
combining the first three columns of the features file in the format of
"chr:start-end".}

\item{returnList}{Logical, used internally by wrapper functions. Whether to
force putting the loaded matrix in a list even if there's only one matrix.
Default \code{FALSE}.}
}
\value{
For a single-modal sample, a dgCMatrix object, or a list of one
dgCMatrix when \code{returnList = TRUE}. A list of multiple dgCMatrix objects
when multiple feature types are detected.
}
\description{
This function works for loading a single sample with specifying the paths to
the matrix.mtx, barcodes.tsv, and features.tsv files. This function is
internally used by \code{\link{read10X}} functions for loading individual
samples from cellranger output directory, while it can also be convenient
when out-of-standard files are presented (e.g. data downloaded from GEO).
}
\examples{
\dontrun{
matrix <- read10XFiles(
    matrixPath = "path/to/matrix.mtx.gz",
    barcodesPath = "path/to/barcodes.tsv.gz",
    featuresPath = "path/to/features.tsv.gz"
)
}
}
