% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolr-functions.R
\name{rhier}
\alias{rhier}
\title{Finding Optimal Cutpoints Using a Hierarchical Method}
\usage{
rhier(times, status, x, ns = 15, alt = "decrease", method = "approximate")
}
\arguments{
\item{times}{Survival outcome.}

\item{status}{Censoring indicator which takes 1 when an event occurs at end
of study and 0 otherwise.}

\item{x}{A continuous covariate.}

\item{ns}{Minimum number of subjects in each group after dichotomizing the
covariate.}

\item{alt}{A character that takes either \code{"decrease"} or \code{"increase"}
to represent a positive or negative association between the covariate
and survival.}

\item{method}{A character that takes either \code{"approximate"} or
\code{"exact"} where an approximate or exact method will be used.}
}
\value{
Returns a list with one element being the two optimal cutpoints obtained.
}
\description{
Using a hierarchical method, \code{rhier} is used to find two optimal
  cutpoints to divide the entire dataset into three groups based on a
  continuous covariate and a survival outcome. Making use of the running
  logrank test (\code{\link{rlr}}), the method first identifies an optimal
  cutpoint that gives the largest logrank statistic to split into two groups,
  and then repeats the process in each of the resulting groups to find
  additional two cutpoints. It then takes the cutpoint that gives the larger
  test statistic between the two as the second optimal cutpoint.
}
\examples{
library(rolr)

#simulate data with true underlying cutpoints and hazard goes up as covariate goes up
d=simdata(nn = 150, hr = c(1, 2, 3), hazard.func = "step",
          props=c(1/3, 1/3, 1/3), censoring.rate = 0)

#finding optimal cutpoints using alt = 'decrease' option
res=rhier(times=d$times, status=d$status, x=d$x, ns=15, alt='decrease')

#do it again using alt = 'increase', the results are the same as earlier
#because it doesn't matter what you choose for the alt option
res2=rhier(times=d$times, status=d$status, x=d$x, ns=15, alt='increase')


}
\references{
See main package help page.
}
\seealso{
\code{\link{rsolr12}}, \code{\link{rmolr}}
}

