% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics-ANTsTransform.R
\name{is_affine3D}
\alias{is_affine3D}
\alias{is_affine3D.default}
\alias{is_affine3D.ants.core.ants_transform.ANTsTransform}
\title{Check if an object is a 3D 'affine' transform matrix}
\usage{
is_affine3D(x, ...)

\method{is_affine3D}{default}(x, strict = TRUE, ...)

\method{is_affine3D}{ants.core.ants_transform.ANTsTransform}(x, ...)
}
\arguments{
\item{x}{R or Python object, accepted forms are numeric \code{matrix},
\code{'ANTsTransform'}, or \code{character} (path to transform matrix)}

\item{...}{passed to other methods}

\item{strict}{whether the last element should be always 1}
}
\value{
A logical value whether the object can be loaded as a 4-by-4 matrix.
}
\description{
Check if an object is a 3D 'affine' transform matrix
}
\examples{

# not affine
is_affine3D(1)

# 3x3 matrix is not as it is treated as 2D transform
is_affine3D(matrix(rnorm(9), nrow = 3))

# 3x4 matrix
x <- matrix(rnorm(12), nrow = 3)
is_affine3D(x)

# 4x4 matrix
x <- rbind(x, c(0,0,0,1))
is_affine3D(x)

if(interactive() && ants_available()) {

  ants <- load_ants()
  x <- ants$new_ants_transform(dimension = 3L)
  is_affine3D(x)

  # save the parameters
  f <- tempfile(fileext = ".mat")
  ants$write_transform(x, f)
  is_affine3D(f)

}




}
