% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{rrda.predict}
\alias{rrda.predict}
\title{Calculate the predicted matrix Yhat using the coefficient Bhat obtained from the \code{rrda.fit} function.}
\usage{
rrda.predict(Bhat, X, nrank = NULL, lambda = NULL)
}
\arguments{
\item{Bhat}{A list of vectors of Bhat components, obtained by the \code{rrda.fit} function.}

\item{X}{A numeric matrix of explanatory variables.}

\item{nrank}{A numeric vector specifying the ranks of Bhat. Default is \code{NULL}, which sets it to the ranks defined in the Bhat components.}

\item{lambda}{A numeric vector of ridge penalty values. Default is \code{NULL}, which sets it to the lambda values defined in the Bhat components.}
}
\value{
A list containing the predicted Yhat matrix, ranks, and lambda values.
}
\description{
This function calculates the predicted response matrix (Yhat) using Bhat (the coefficient of Ridge Redundancy Analysis) obtained from the rrda.fit function. The user can specify the ranks and lambda values to be used for the prediction. If not provided, the ranks and lambda values are set based on the Bhat components. The function returns the predicted Yhat matrix, as well as the ranks and lambda values used.

The predicted response matrix is calculated as:
\deqn{\hat{Y}_r = X \left( \sum_{i=1}^{r} (F_{.i} G_{.i}^{\prime}) \right)
= \sum_{i=1}^{r} (X F_{.i} G_{.i}^{\prime})
= \sum_{i=1}^{r} (\tilde{X}_{.i} G_{.i}^{\prime})}

Here, \eqn{\tilde{X} = X F}, and \eqn{r} is the rank of \eqn{\hat{B}(\lambda, r)}.
The regularized-rank-restricted estimation of \eqn{B} is obtained from the \code{rrda.fit} function:
\deqn{\hat{B}(\lambda, r) = FG^{\prime}}
}
\examples{
set.seed(10)
simdata<-rdasim1(n = 100,p = 200,q = 200,k = 5)
X <- simdata$X
Y <- simdata$Y
Bhat <- rrda.fit(Y = Y, X = X, nrank = c(1:10))
Yhat_mat <- rrda.predict(Bhat = Bhat, X = X, nrank = 10)
}
