% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relu.R
\name{dReLU}
\alias{dReLU}
\title{Derivative of the Rectified Linear Unit (ReLU) Activation Function}
\usage{
dReLU(x)
}
\arguments{
\item{x}{A numeric vector. All elements must be finite and
non-missing.}
}
\value{
A numeric vector where the derivative of the ReLU function
}
\description{
This function applies the derivative of the Rectified Linear Unit
(ReLU) activation function to the input numeric vector.
}
\examples{

dReLU(c(-1, 0, 1, 2))

# Can also be used in rxode2:
x <- rxode2({
   r=dReLU(time)
})

e <- et(c(-1, 0, 1, 2))

rxSolve(x, e)
}
\seealso{
Other Activation Functions: 
\code{\link{ELU}()},
\code{\link{GELU}()},
\code{\link{PReLU}()},
\code{\link{ReLU}()},
\code{\link{SELU}()},
\code{\link{Swish}()},
\code{\link{dELU}()},
\code{\link{dGELU}()},
\code{\link{dPReLU}()},
\code{\link{dSELU}()},
\code{\link{dSwish}()},
\code{\link{dlReLU}()},
\code{\link{dsoftplus}()},
\code{\link{lReLU}()},
\code{\link{softplus}()}
}
\concept{Activation Functions}
