% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnv.R
\name{cnv}
\alias{cnv}
\title{Infer Copy Number Variations (CNVs) in Cancer Cells from ATAC-seq Fragment Overlap}
\usage{
cnv(
  fragmentoverlap,
  windowcovariates,
  levels = c(2, 4),
  nfragspercellmin = 5000,
  nfragspercellmax = 10^5.5,
  deltaBICthreshold = 0
)
}
\arguments{
\item{fragmentoverlap}{Frequency of fragment overlap in each cell-window
computed by the function \code{fragmentoverlapcount}.
\code{barcode} should be named as \code{AAACGAAAGATTGACA-1.window_1},
which represents cell \code{AAACGAAAGATTGACA-1} and window \code{window_1}.
The format is "cell barcode", ".window_" and integer.}

\item{windowcovariates}{Chromosomal windows for which copy number
gain/loss are initially inferred. Required columns are chr, start, end,
window (for example, \code{window_1}) and peaks.
Peaks is a numeric column representing chromatin accessibility.}

\item{levels}{Possible values of ploidy. For example,
\code{c(2, 4)} if the cells can be diploids or tetraploids.
The values must be larger than one.}

\item{nfragspercellmin}{Minimum number of fragments for a cell-window to be eligible.}

\item{nfragspercellmax}{Maximum number of fragments for a cell-window to be eligible.}

\item{deltaBICthreshold}{Only the CNVs with deltaBIC smaller than this threshold
are adopted.}
}
\value{
A list with two elements.
\code{CNV} is a data frame of the CNVs identified in the dataset.
\code{cellwindowCN} is a data frame indicating the ploidy for each cell
and the inferred standardized copy number for each cell-window.
}
\description{
Infer Copy Number Variations (CNVs) in Cancer Cells from ATAC-seq Fragment Overlap
}
