% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orders.R
\name{schwab_orderDetail}
\alias{schwab_orderDetail}
\title{Get Details for a Single Order}
\usage{
schwab_orderDetail(orderId, account_number, accessTokenList = NULL)
}
\arguments{
\item{orderId}{A valid Schwab Order ID}

\item{account_number}{A Schwab account number associated with the Access Token}

\item{accessTokenList}{A valid Access Token must be set using the output from
\code{\link{schwab_auth3_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
list of order details
}
\description{
Pass an order ID and Account number to get details such as status, quantity,
ticker, executions (if applicable), account, etc.
}
\examples{
\dontrun{

# Get stored refresh token
refreshToken = readRDS('/secure/location/')

# generate a new access token
accessTokenList = schwab_auth3_accessToken('AppKey', 'AppSecret', refreshToken)

# Get order details for a single order
# Passing Access Token is optional once it's been set
schwab_orderDetail(orderId = 123456789, account_number = 987654321)

}
}
