% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vMF_robust.R
\name{vMF_robust}
\alias{vMF_robust}
\title{Robust Fitting of von Mises Fisher}
\usage{
vMF_robust(Y, cW, ...)
}
\arguments{
\item{Y}{A matrix of observations in Cartesian coordinates.}

\item{cW}{Tuning constants for each parameter in the vMF parameter vector. If a single number then the constant is the same for each element of the parameter vector.}

\item{...}{Passed to \code{\link[=Windham]{Windham()}} and then passed onto \code{\link[=vMF]{vMF()}}.}
}
\description{
Robust estimation for von Mises Fisher distribution using \code{\link[=Windham]{Windham()}}.
}
\examples{
if (requireNamespace("movMF")){
  Y <- movMF::rmovMF(1000, 100 * c(1, 1) / sqrt(2))
} else {
  Y <- matrix(rnorm(1000 * 2, sd = 0.01), ncol = 2)
  Y <- Y / sqrt(rowSums(Y^2))
}
vMF_robust(Y, cW = c(0.01, 0.01), method = "smfull")
vMF_robust(Y, cW = c(0.01, 0.01), method = "Mardia")
}
\seealso{
Other directional model estimators: 
\code{\link{Bingham}()},
\code{\link{FB}()},
\code{\link{vMF}()}

Other Windham robustness functions: 
\code{\link{Windham}()},
\code{\link{ppi_robust}()}
}
\concept{Windham robustness functions}
\concept{directional model estimators}
