% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function-map-total-n.R
\name{function_map_total_n}
\alias{function_map_total_n}
\title{Create new \verb{*_map_total_n()} functions}
\usage{
function_map_total_n(
  .fun,
  .reported,
  .name_test,
  .name_key_result = "consistency",
  .name_class = NULL,
  .dispersion = 0:5,
  .n_min = 1L,
  .n_max = NULL,
  .constant = NULL,
  .constant_index = NULL,
  ...
)
}
\arguments{
\item{.fun}{Function such as \code{\link[=grim_map]{grim_map()}}, or one made by
\code{\link[=function_map]{function_map()}}: It will be used to test columns in a data frame for
consistency. Test results are logical and need to be contained in a column
called \code{consistency} that is added to the input data frame. This modified
data frame is then returned by \code{.fun}.}

\item{.reported}{String. Names of the columns containing group-specific
statistics that were reported alongside the total sample size(s). They will
be tested for consistency with the hypothetical group sizes. Examples are
\code{"x"} for GRIM and \code{c("x", "sd")} for DEBIT. In the data frame with
reported group statistics that the manufactured function takes as an input,
each will need to fan out like \code{"x1"}, \code{"x2"}, \code{"sd1"}, and \code{"sd2"}.}

\item{.name_test}{String (length 1). The name of the consistency test, such
as \code{"GRIM"}, to be optionally shown in a message when using the
manufactured function.}

\item{.name_key_result}{(Experimental) Optionally, a single string that will
be the name of the key result column in the output. Default is
\code{"consistency"}.}

\item{.name_class}{String. If specified, the tibbles returned by the
manufactured function will inherit this string as an S3 class. Default is
\code{NULL}, i.e., no extra class.}

\item{.dispersion, .n_min, .n_max, .constant, .constant_index}{Arguments passed
down to \code{\link[=disperse_total]{disperse_total()}}, using defaults from there.}

\item{...}{These dots must be empty.}
}
\value{
A function such as these:\tabular{lll}{
   \strong{Manufactured function} \tab \strong{Reported statistics} \tab \strong{Test vignette} \cr
   \code{\link[=grim_map_total_n]{grim_map_total_n()}} \tab \code{"x"} \tab \code{vignette("grim")} \cr
   \code{\link[=grimmer_map_total_n]{grimmer_map_total_n()}} \tab \code{"x"}, \code{"sd"} \tab \code{vignette("grimmer")} \cr
   \code{\link[=debit_map_total_n]{debit_map_total_n()}} \tab \code{"x"}, \code{"sd"} \tab \code{vignette("debit")} \cr
}


The factory-made function will also have dots, \code{...}, to pass arguments
down to \code{.fun}, i.e., the basic mapper function.
}
\description{
\code{function_map_total_n()} is the engine that powers functions
such as \code{\link[=grim_map_total_n]{grim_map_total_n()}}. It creates new, "factory-made" functions
for consistency tests such as GRIM or GRIMMER. The new functions take
reported summary statistics (e.g., means) and apply those tests in cases
where only a total sample size is known, not group sizes.

This works by making \code{\link[=disperse_total]{disperse_total()}} create multiple pairs of
hypothetical group sizes, all of which add up to the reported total. There
need to be exactly two groups.

For background and more examples, see the
\href{https://lhdjung.github.io/scrutiny/articles/consistency-tests.html#total-n-mapper}{total-n
mapper section} of \emph{Consistency tests in depth}.
}
\details{
If functions created by \code{function_map_total_n()} are exported from
other packages, they should be written as if they were created with
\href{https://purrr.tidyverse.org/reference/faq-adverbs-export.html}{purrr
adverbs}; see explanations there, and examples in the
\href{https://lhdjung.github.io/scrutiny/articles/consistency-tests.html#context-and-export}{export
section} of \emph{Consistency tests in depth}.

This function is a so-called function factory: It produces other functions,
such as \code{\link[=grim_map_total_n]{grim_map_total_n()}}. More specifically, it is a function
operator because it also takes functions as inputs, such as \code{\link[=grim_map]{grim_map()}}.
See Wickham (2019), ch. 10-11.
}
\section{Conventions}{
 The name of a function returned by
\code{function_map_total_n()} should mechanically follow from that of
the input function. For example, \code{\link[=grim_map_total_n]{grim_map_total_n()}} derives
from \code{\link[=grim_map]{grim_map()}}. This pattern fits best if the input function itself
is named after the test it performs on a data frame, followed by \verb{_map}:
\code{\link[=grim_map]{grim_map()}} applies GRIM, \code{\link[=grimmer_map]{grimmer_map()}} applies GRIMMER, etc.

Much the same is true for the classes of data frames returned by the
manufactured function via the \code{.name_class} argument of
\code{function_map_total_n()}. It should be the function's own name preceded
by the name of the package that contains it, or by an acronym of that
package's name. Therefore, some existing classes are
\code{scr_grim_map_total_n} and \code{scr_grimmer_map_total_n}.
}

\examples{
# Function definition of `grim_map_total_n()`:
grim_map_total_n <- function_map_total_n(
  .fun = grim_map,
  .reported = "x",
  .name_test = "GRIM"
)
}
\references{
Bauer, P. J., & Francis, G. (2021). Expression of Concern: Is It
Light or Dark? Recalling Moral Behavior Changes Perception of Brightness.
\emph{Psychological Science}, 32(12), 2042–2043.
https://journals.sagepub.com/doi/10.1177/09567976211058727

Wickham, H. (2019). \emph{Advanced R} (Second Edition). CRC Press/Taylor and
Francis Group. https://adv-r.hadley.nz/index.html
}
\seealso{
\code{\link[=function_map_seq]{function_map_seq()}}
}
