% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_delta_model}
\alias{set_delta_model}
\title{Set delta model for \code{\link[ggeffects:ggpredict]{ggeffects::ggpredict()}}}
\usage{
set_delta_model(x, model = c(NA, 1, 2))
}
\arguments{
\item{x}{An \code{\link[=sdmTMB]{sdmTMB()}} model fit with a delta family such as
\code{\link[=delta_gamma]{delta_gamma()}}.}

\item{model}{Which delta/hurdle model component to predict/plot with.
\code{NA} does the combined prediction, \code{1} does the binomial part, and \code{2}
does the positive part.}
}
\value{
The fitted model with a new attribute named \code{delta_model_predict}.
We suggest you use \code{set_delta_model()} in a pipe (as in the examples)
so that this attribute does not persist. Otherwise, \code{\link[=predict.sdmTMB]{predict.sdmTMB()}}
will choose this model component by default. You can also remove the
attribute yourself after:

\if{html}{\out{<div class="sourceCode">}}\preformatted{attr(fit, "delta_model_predict") <- NULL
}\if{html}{\out{</div>}}
}
\description{
Set a delta model component to predict from with \code{\link[ggeffects:ggpredict]{ggeffects::ggpredict()}}.
}
\details{
A complete version of the examples below would be:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fit <- sdmTMB(density ~ poly(depth_scaled, 2), data = pcod_2011,
  spatial = "off", family = delta_gamma())

# binomial part:
set_delta_model(fit, model = 1) |>
  ggeffects::ggpredict("depth_scaled [all]")

# gamma part:
set_delta_model(fit, model = 2) |>
  ggeffects::ggpredict("depth_scaled [all]")

# combined:
set_delta_model(fit, model = NA) |>
  ggeffects::ggpredict("depth_scaled [all]")
}\if{html}{\out{</div>}}

But cannot be run on CRAN until a version of \pkg{ggeffects} > 1.3.2
is on CRAN. For now, you can install the GitHub version of \pkg{ggeffects}.
\url{https://github.com/strengejacke/ggeffects}.
}
\examples{
\dontshow{if (require("ggeffects", quietly = TRUE)) withAutoprint(\{ # examplesIf}
fit <- sdmTMB(density ~ poly(depth_scaled, 2), data = pcod_2011,
  spatial = "off", family = delta_gamma())

# binomial part:
set_delta_model(fit, model = 1)

# gamma part:
set_delta_model(fit, model = 2)

# combined:
set_delta_model(fit, model = NA)
\dontshow{\}) # examplesIf}
}
