% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance-metrics.R
\name{calc_temporal_coverage}
\alias{calc_temporal_coverage}
\title{Calculate Temporal Coverage Metrics}
\usage{
calc_temporal_coverage(search_results, target_date_range = NULL)
}
\arguments{
\item{search_results}{Data frame with search results including date column}

\item{target_date_range}{Vector of two dates defining the target time period}
}
\value{
List containing temporal coverage statistics
}
\description{
Calculate Temporal Coverage Metrics
}
\details{
Analyzes the temporal distribution of search results:
\itemize{
\item \strong{coverage_by_year}: Number of articles by publication year
\item \strong{target_period_coverage}: Proportion of results in target date range
\item \strong{temporal_gaps}: Years with no results in the target period
\item \strong{peak_years}: Years with highest number of results
}
}
\examples{
# Create sample data
search_results <- data.frame(
  id = paste0("art", 1:20),
  date = seq(as.Date("2010-01-01"), as.Date("2023-12-31"), length.out = 20)
)
target_range <- c(as.Date("2015-01-01"), as.Date("2020-12-31"))

temporal_metrics <- calc_temporal_coverage(search_results, target_range)
print(temporal_metrics$target_period_coverage)
}
