% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{influencer_data}
\alias{influencer_data}
\title{Measurement Instrument for the Influencer Model}
\format{
A data frame with 250 rows and 24 variables:
\describe{

  \item{sic_1}{The influencer reflects who I am.}
  \item{sic_2}{I can identify with the influencer.}
  \item{sic_3}{I feel a personal connection to the influencer.}
  \item{sic_4}{I (can) use the influencer to communicate who I am to other people.}
  \item{sic_5}{I think the influencer (could) help(s) me become the type of person I want to be.}
  \item{sic_6}{I consider the influencer to be "me".}
  \item{sic_7}{The influencer suits me well.}
  \item{sic_global}{My personality and the personality of the influencer relate accordingly to one another.}
  \item{pq_1}{The product has excellent quality.}
  \item{pq_2}{The product looks to be reliable and durable.}
  \item{pq_3}{The product will have fewer problems.}
  \item{pq_4}{The product has excellent quality features.}
  \item{pl_1}{I dislike the product (reverse coded).}
  \item{pl_2}{The product is appealing to me.}
  \item{pl_3}{The presented product raises a positive feeling in me.}
  \item{pl_4}{The product is interesting to me.}
  \item{pi_1}{It is very likely that I will purchase this product.}
  \item{pi_2}{I will purchase this product the next time I need it.}
  \item{pi_3}{I would definitely try the product out.}
  \item{pi_4}{I would recommend this product to my friends.}
  \item{pi_5}{I am willing to purchase this product.}
  \item{pic_1}{The influencer is qualified.}
  \item{pic_2}{The influencer is competent.}
  \item{pic_3}{The influencer is an expert.}
  \item{pic_4}{The influencer is experienced.}
  \item{pic_5}{The influencer is knowledgeable.}
  \item{wtp}{Please state your willingness to pay (in Euro) for the presented product.}
  \item{influencer_group}{A binary variable indicating which group the influencer belongs to.}
}
}
\usage{
influencer_data
}
\description{
The data set is used as measurement instrument for the Influencer Model which is used in
Partial Least Squares Structural Equation Modeling (PLS-SEM) Using R - A Workbook (2021)
Hair, J.F. (Jr), Hult, T.M., Ringle, C.M., Sarstedt, M., Danks, N.P., and Ray, S.
}
\details{
The data frame influencer_data contains the observed data for the model specified in the Influencer Model.
}
\examples{
data("influencer_data")

}
\keyword{datasets}
