% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_plspredict.R
\name{predict_pls}
\alias{predict_pls}
\title{Predict_pls performs either k-fold or LOOCV on a SEMinR PLS model and generates predictions}
\usage{
predict_pls(model, technique, noFolds, reps, cores)
}
\arguments{
\item{model}{A SEMinR model that has been estimated on the FULL dataset.}

\item{technique}{The predictive technique to be employed, Earliest Antecedents (EA) \code{predict_EA} or
Direct Antecedents (DA) \code{predict_DA}}

\item{noFolds}{The required number of folds to use in k-fold cross validation. If NULL, then parallel LOOCV will be executed.
Default is NULL.}

\item{reps}{The number of times the cross-validation will be repeated. Default is NULL.}

\item{cores}{The number of cores to use for parallel LOOCV processing. If k-fold is used, the process will not be parallelized.}
}
\value{
A list of the estimated PLS and LM prediction results:
 \item{PLS_out_of_sample}{A matrix of the out-of-sample indicator predictions generated by the SEMinR model.}
 \item{PLS_in_sample}{A matrix of the in-sample indicator predictions generated by the SEMinR model.}
 \item{lm_out_of_sample}{A matrix of the out-of-sample indicator predictions generated by a linear regression model.}
 \item{lm_in_sample}{A matrix of the in-sample indicator predictions generated by a linear regression model.}
 \item{item_actuals}{A matrix of the actual indicator scores.}
 \item{PLS_out_of_sample_residuals}{A matrix of the out-of-sample indicator PLS prediction residuals.}
 \item{PLS_in_sample_residuals}{A matrix of the in-sample indicator PLS prediction residuals.}
 \item{lm_out_of_sample_residuals}{A matrix of the out-of-sample LM indicator prediction residuals.}
 \item{lm_in_sample_residuals}{A matrix of the in-sample LM indicator prediction residuals.}
 \item{mmMatrix}{A Matrix of the measurement model relations.}
 \item{smMatrix}{A Matrix of the structural model relations.}
 \item{constructs}{A vector of the construct names.}
 \item{mmVariables}{A vector of the indicator names.}
 \item{outer_loadings}{The matrix of estimated indicator loadings.}
 \item{outer_weights}{The matrix of estimated indicator weights.}
 \item{path_coef}{The matrix of estimated structural model relationships.}
 \item{iterations}{A numeric indicating the number of iterations required before the algorithm converged.}
 \item{weightDiff}{A numeric indicating the minimum weight difference between iterations of the algorithm.}
 \item{construct_scores}{A matrix of the estimated construct scores for the PLS model.}
 \item{rSquared}{A matrix of the estimated R Squared for each construct.}
 \item{inner_weights}{The inner weight estimation function.}
 \item{data}{A matrix of the data upon which the model was estimated (INcluding interactions.}
 \item{rawdata}{A matrix of the data upon which the model was estimated (EXcluding interactions.}
 \item{measurement_model}{The SEMinR measurement model specification.}
}
\description{
\code{predict_pls} uses cross-validation to generate in-sample and out-sample predictions for PLS models generated by SEMinR.
}
\details{
This function generates cross-validated in-sample and out-sample predictions for PLS models generated by SEMinR. The
cross validation technique can be k-fold if a number of folds are specified, or leave-one-out-cross-validation (LOOCV) if no folds
arew specified. LOOCV is recommended for small datasets.
}
\examples{
data(mobi)

# seminr syntax for creating measurement model
mobi_mm <- constructs(
  composite("Image",        multi_items("IMAG", 1:5)),
  composite("Expectation",  multi_items("CUEX", 1:3)),
  composite("Value",        multi_items("PERV", 1:2)),
  composite("Satisfaction", multi_items("CUSA", 1:3))
)

mobi_sm <- relationships(
  paths(to = "Satisfaction",
        from = c("Image", "Expectation", "Value"))
)

mobi_pls <- estimate_pls(mobi, mobi_mm, mobi_sm)
cross_validated_predictions <- predict_pls(model = mobi_pls,
                                           technique = predict_DA,
                                           noFolds = 10,
                                           cores = NULL)

}
