% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_functions.R
\name{ishigami_Fun}
\alias{ishigami_Fun}
\title{Ishigami function}
\usage{
ishigami_Fun(X)
}
\arguments{
\item{X}{A data frame or numeric matrix where each column is a model input and each
row a sample point.}
}
\value{
A numeric vector with the model output.
}
\description{
It implements the \insertCite{Ishigami1990;textual}{sensobol} function.
}
\details{
The function requires 3 model inputs and reads as
\deqn{y=\sin(x_1) +a \sin(x_2) ^ 2 + b x_3 ^4 \sin(x_1)\,,}
where \eqn{a=2}, \eqn{b=1} and \eqn{(x_1,x_2,x_3)\sim\mathcal{U}(-\pi, +\pi)}. The
transformation of the distribution of the model inputs from \eqn{U(0, 1)} to
\eqn{U(-\pi, +\pi)}) is conducted internally.
}
\examples{
# Define settings
N <- 100; params <- paste("X", 1:3, sep = "")

# Create sample matrix
mat <- sobol_matrices(N = N, params = params)

# Compute Ishigami function
Y <- ishigami_Fun(mat)
}
\references{
\insertAllCited{}
}
