% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{MRPWorkflow-method-estimate_map}
\alias{MRPWorkflow-method-estimate_map}
\alias{estimate_map}
\title{Create a choropleth map of MRP estimates}
\usage{
estimate_map(
  model,
  geo = NULL,
  time_index = NULL,
  interval = 0.95,
  file = NULL
)
}
\arguments{
\item{model}{Fitted MRPModel object}

\item{geo}{Character string specifying the geographic level for mapping.
Options include geography for data linking and those at larger scales.
A "linking" geography is required to use this method. It is either specified
as \code{geo} in the \verb{$link_acs()} method or the smallest common geographic scale
between the sample data and the custom poststratification data
input using \verb{$load_pstrat()}.}

\item{time_index}{Integer specifying the time index for time-varying data.}

\item{interval}{Confidence interval (a numeric value between 0 and 1) or
standard deviation (\code{"1sd"} or \code{"2sd"}) for the estimates (default is 0.95).}

\item{file}{Optional file path with .html extension to save the interactive map.
Expand the hamburger menu in the top right corner of the map to access other export options.}
}
\value{
A highcharter map object showing MRP estimates by geography.
}
\description{
The \verb{$estimate_map()} method creates interactive choropleth maps that show MRP estimates by geographic region.
This method cannot be used if either the sample or the poststratification data contains no geographic information.
Check out the \href{https://mrp-interface.github.io/shinymrp/articles/example#estimate_map}{More examples of R6 classes}
vignette for usage examples.
}
