% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{MRPWorkflow-method-preprocess}
\alias{MRPWorkflow-method-preprocess}
\alias{preprocess}
\title{Preprocess sample data}
\usage{
preprocess(
  data,
  is_timevar = FALSE,
  is_aggregated = FALSE,
  special_case = NULL,
  family = NULL,
  time_freq = NULL,
  freq_threshold = 0
)
}
\arguments{
\item{data}{An object of class \code{data.frame} (or one that can be coerced to that class) that satisfies
the requirements specified in the \href{https://mrp-interface.github.io/shinymrp/articles/data-prep}{More on data preparation} vignette.}

\item{is_timevar}{Logical indicating whether the data contains time-varying components.}

\item{is_aggregated}{Logical indicating whether the data is already aggregated.}

\item{special_case}{Character string specifying special case handling. Options are \code{NULL} (the default), \code{"covid"}, and \code{"poll"}.}

\item{family}{Character string specifying the distribution family for the outcome variable. Options are \code{"binomial"} for binary outcome measures and \code{"normal"} for continuous outcome measures.}

\item{time_freq}{Character string specifying the time indexing frequency or time length for grouping dates (YYYY-MM-DD) in the data.
Options are \code{NULL} (the default), \code{"week"}, \code{"month"}, and \code{"year"}. This parameter must be \code{NULL} for cross-sectional data
or time-varying data that already has time indices.}

\item{freq_threshold}{Numeric value specifying the minimum frequency threshold for including observations.
Values with lower frequency will cause the entire row to be removed. The default value is 0 (no filtering).}
}
\value{
No return value, called for side effects.
}
\description{
The \verb{$preprocess()} method runs the preprocessing pipeline
that includes data standardization, filtering, imputation, and aggregation.
See the \href{https://mrp-interface.github.io/shinymrp/articles/data-prep}{More on data preparation}
vignette for more information about data processing. For usage examples, refer to the
\href{https://mrp-interface.github.io/shinymrp/articles/example#preprocess}{More examples of R6 classes}
vignette.
}
