% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-from-simulation.R
\name{evals}
\alias{evals}
\title{Get one or more evals from a simulation}
\usage{
evals(sim, ..., subset = NULL, index, methods, reference = FALSE)
}
\arguments{
\item{sim}{a simulation object}

\item{...}{logical conditions to specify a subset of models.  Conditions can
only involve params of model that have length 1 and are of class
numeric or character.}

\item{subset}{a vector of integers indexing the models or a vector of model
names. To select models based on parameter values, use \code{...}.
However, using \code{...} is slower than using subset.}

\item{index}{a vector of positive integers specifying which draws' objects
are desired. If missing, then all draws' evals are returned.}

\item{methods}{character vector of method names of interest.  If missing,
then all methods' evals are returned}

\item{reference}{whether to return the ModelRef or the Model object itself}
}
\description{
Returns either the Evals object itself or a reference to it.
}
\examples{
\dontrun{
 # suppose previously we had run the following:
 sim <- new_simulation(name = "normal-example",
                       label = "Normal Mean Estimation",
                       dir = tempdir()) \%>\%
   generate_model(make_my_example_model, n = 20) \%>\%
   simulate_from_model(nsim = 50, index = 1:3) \%>\%
   run_method(my_example_method) \%>\%
   evaluate(my_example_loss)
 # then we could get the metric evaluated on the method's output:
 e <- evals(sim)
 # we can export it as a data.frame
 as.data.frame(e)
 # or we can get at a particular draw-method-metric triplet
 e@evals$`my-method`$r1.1$myloss
 }
}
\seealso{
\code{\link{as.data.frame}}
}
