% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_eval_by.R
\name{plot_eval_by}
\alias{plot_eval_by}
\title{Plot a metric across multiple values of a model parameter}
\usage{
plot_eval_by(
  sim,
  metric_name,
  varying,
  type = c("aggregated", "raw"),
  center_aggregator = NULL,
  spread_aggregator = NULL,
  use_ggplot2 = TRUE,
  main,
  xlab,
  ylab,
  xlim,
  ylim,
  include_zero = FALSE,
  legend_location = "topright",
  method_col = seq(num_methods),
  method_lty = rep(1, num_methods),
  method_lwd = rep(1, num_methods),
  method_pch = rep(1, num_methods),
  ...
)
}
\arguments{
\item{sim}{an object of class \code{\linkS4class{Simulation}}}

\item{metric_name}{the name of a metric to plot (ignored if custom
aggregator is provided)}

\item{varying}{character vector giving the name of a parameter that is
varied across the models in evals. For now, this parameter must be
numeric and there cannot be multiple models having the same value
of this parameter.}

\item{type}{if "aggregated" then shows line with error bars (line represents
center_aggregator and error bars represent spread_aggregator; by
default these are sample mean and estimated standard error); if
\code{type} is "raw" then shows the raw data as points (with smoother
overlayed)}

\item{center_aggregator}{ignored if \code{type} is "raw".  When NULL (which
is default), the sample mean aggregator is used.  User can write
specialized aggregators (see definition of class
\code{\linkS4class{Aggregator}}) as necessary, for example, when the
evaluated metric is not scalar-valued.}

\item{spread_aggregator}{ignored if \code{type} is "raw".  When NULL (which
is default), the sample mean aggregator is used.  User can write
specialized aggregators (see definition of class
\code{\linkS4class{Aggregator}}) as necessary, for example, when the
evaluated metric is not scalar-valued. Set \code{spread_aggregator}
to \code{NA} to hide error bars.}

\item{use_ggplot2}{whether to use \code{ggplot2} (requires installation
of \code{ggplot2})}

\item{main}{title of plot.}

\item{xlab}{the x-axis label (default is \code{varying})}

\item{ylab}{the y-axis label (default is \code{metric_label})}

\item{xlim}{the x-axis limits to use}

\item{ylim}{the y-axis limits to use}

\item{include_zero}{whether ylim should include 0.  Ignored if ylim
is passed explicitly}

\item{legend_location}{location of legend.  Set to NULL to remove legend.}

\item{method_col}{color to use for each method}

\item{method_lty}{line style to use for each method}

\item{method_lwd}{line thickness to use for each method}

\item{method_pch}{point style to use for each method (default is that no
points, only lines are drawn)}

\item{...}{additional arguments to pass to \code{plot} (only when
\code{use_ggplot2 = FALSE}).}
}
\description{
This function is to be used on simulations in which
\code{\link{generate_model}} was called using the \code{vary_along}
parameter.  When this is a single (scalar) numeric parameter, a single plot
is created in which the x-axis is this parameter.  Eventually, this function
should handle one or two categorical variables (in which facets are used)
and one categorical combined with one continuous variable.
}
\details{
When \code{type} is "raw", the individual evals are shown (one point per
model-draw-method triplet) along with a loess smooth.  When \code{type} is
"aggregated", then \code{center_aggregator} and \code{spread_aggregator}
are used.  \code{center_aggregator} is used to draw a single line per method
in which the individual evals computed for each draw has been been
aggregated in some way.  By default, the \code{mean_aggregator} is used,
which simply averages the evals computed across all draws.  When
\code{spread_aggregator} is non-NULL, "error bars" are drawn with
(half)widths computed using \code{spread_aggregator}.  By default, the
\code{se_aggregator} is used, which gives an estimate of the standard error
of the sample mean.

The arguments method_col, method_lty, method_lwd, method_pch only
apply when use_ggplot2 is FALSE.
}
\examples{
\dontrun{
 # suppose previously we had run the following:
 sim <- new_simulation(name = "normal-example",
                       label = "Normal Mean Estimation",
                       dir = tempdir()) \%>\%
   generate_model(make_my_example_model,
                  n = list(10, 20, 30),
                  vary_along = "n") \%>\%
   simulate_from_model(nsim = 50, index = 1:3) \%>\%
   run_method(my_example_method) \%>\%
   evaluate(my_example_loss)
   # then we could plot this
   plot_eval_by(sim, "myloss", varying = "n", include_zero = TRUE)
 }
}
